SET TERM ^ ;

create or alter procedure EVENT_ANALIT (
    ID_DB integer,
    ID_DEV integer,
    ID_PEP integer,
    ID_EVENTTYPE integer)
returns (
    ANALIT_CODE integer)
as
declare variable SINGLE_LIST integer;
declare variable CARD varchar(32);
declare variable CARD_FOR_DELETE integer;
declare variable CARD_FOR_LOAD integer;
declare variable CARD_IS_ACTIVE integer;
declare variable PEOPLE_IS_ACTIVE integer;
declare variable PASS_IS_VALIDE integer;
begin

   people_is_active=0;
   card_is_active=0;
   pass_is_valide=0;
   analit_code=-1;
   card_for_delete=0;
   card_for_load=0;
   select p."ACTIVE" from people p where p.id_pep=:id_pep and p.id_db=1 into :people_is_active;
   select c.id_card, c."ACTIVE" from card c where c.id_pep=:id_pep and c.id_db=1 into :card,  :card_is_active;

   if (exists (
                select * from ss_accessuser ssa
                    join access ac on ssa.id_accessname=ac.id_accessname and ac.id_db=ssa.id_db
                    where ssa.id_pep=:id_pep and ac.id_dev=:id_dev and ssa.id_db=1
                )) then
                /*Пользователь может ходить через эту точку прохода*/
                          pass_is_valide=1;
                         else
                /*Пользователь НЕ имеет право прохода через эту точку прохода.';  */
                        pass_is_valide=0;
     /*Анализ возможных комбинаций*/
    if(:id_eventtype = 50) then  /*Анализ для события 50 - действительная карта*/
        begin
           /*Проверяю наличие карты в очереди на удаление*/
           if(exists(select * from cardindev cd where cd.id_dev=:id_dev and cd.id_card=:card and cd.operation=2 and cd.id_db=1)) then card_for_delete=1;
           /*Проверяю наличие метки Единый список у обрабатывающего контроллера*/
           select BITAND(d2.flag, 1) from device d
               join device d2 on d2.id_ctrl=d.id_ctrl and d2.id_reader is null
               where d.id_dev=:id_dev into :single_list;
               /*Если есть метка единого списка, то надо проверить возможность прохода через канал 1.*/
           /*Выполняю проверку всех возможных комбинаций*/
           if((:people_is_active = 0) and (:card_is_active = 0) and (:pass_is_valide = 0) ) then analit_code=500;  /*Ошибка! Карта не должна ходить! Пользователь и карты не активны, проход запрещен.*/
           if((:people_is_active = 0) and (:card_is_active = 0) and (:pass_is_valide = 1) ) then analit_code=501;  /*Ошибка! Карта не должна ходить!*/
           if((:people_is_active = 0) and (:card_is_active = 1) and (:pass_is_valide = 0) ) then analit_code=502;  /*Ошибка! Карта не должна ходить!*/
           if((:people_is_active = 0) and (:card_is_active = 1) and (:pass_is_valide = 1) ) then analit_code=503;  /*Ошибка! Карта не должна ходить!*/
           if((:people_is_active = 1) and (:card_is_active = 0) and (:pass_is_valide = 0) ) then analit_code=504;  /*Ошибка! Карта не должна ходить!*/
           if((:people_is_active = 1) and (:card_is_active = 0) and (:pass_is_valide = 1) ) then analit_code=505;  /*Ошибка! Карта не должна ходить!*/
           if((:people_is_active = 1) and (:card_is_active = 1) and (:pass_is_valide = 0) ) then analit_code=506;  /*Ошибка! Карта не должна ходить!*/
           if((:people_is_active = 1) and (:card_is_active = 1) and (:pass_is_valide = 1) and (:card_for_delete=0)) then analit_code=507; /*Ошибки нет, проход разрешен*/
           if((:people_is_active = 1) and (:card_is_active = 1) and (:pass_is_valide = 1) and (:card_for_delete=1) and (:single_list=0)) then analit_code=508; /*Ошибка СКУД. Такой комбинации быть не должно*/
           if((:people_is_active = 1) and (:card_is_active = 1) and (:pass_is_valide = 1) and (:card_for_delete=1) and (:single_list=1)) then analit_code=509; /*Ошибки нет, проход разрешена. Стоит метка Единый список*/
         end

     if(:id_eventtype = 65) then  /*Анализ для осбытия 65 - недействительная карта*/
        begin
           if(exists(select * from cardindev cd where cd.id_dev=:id_dev and cd.id_card=:card and cd.operation=1 and cd.id_db=1)) then card_for_load=1;
           if((:people_is_active = 0) and (:card_is_active = 0) and (:pass_is_valide = 0) ) then analit_code=650;   /*Отказ в проходе правильный.*/
           if((:people_is_active = 0) and (:card_is_active = 0) and (:pass_is_valide = 1) ) then analit_code=651;   /*Отказ в проходе правильный.*/
           if((:people_is_active = 0) and (:card_is_active = 1) and (:pass_is_valide = 0) ) then analit_code=652;   /*Отказ в проходе правильный.*/
           if((:people_is_active = 0) and (:card_is_active = 1) and (:pass_is_valide = 1) ) then analit_code=653;   /*Отказ в проходе правильный.*/
           if((:people_is_active = 1) and (:card_is_active = 0) and (:pass_is_valide = 0) ) then analit_code=654;   /*Отказ в проходе правильный.*/
           if((:people_is_active = 1) and (:card_is_active = 0) and (:pass_is_valide = 1) ) then analit_code=655;   /*Отказ в проходе правильный.*/
           if((:people_is_active = 1) and (:card_is_active = 1) and (:pass_is_valide = 0) ) then analit_code=656;   /*Отказ в проходе правильный.*/
           if((:people_is_active = 1) and (:card_is_active = 1) and (:pass_is_valide = 1) and (:card_for_delete=0)) then analit_code=507;  /*Ошибка! Карта должна ходить.*/
           if((:people_is_active = 1) and (:card_is_active = 1) and (:pass_is_valide = 1) and (:card_for_delete=1)) then analit_code=508;  /*Переходное состояние! Надо дождаться загузки карты в контроллер.*/


        end

end^

SET TERM ; ^

DESCRIBE PROCEDURE EVENT_ANALIT
'Процедура выполняется анализ события.
Предполагается, что на основе этого анализа будут предприняты меры, исправляющие ошибку в работе СКУД.';

GRANT SELECT ON PEOPLE TO PROCEDURE EVENT_ANALIT;

GRANT SELECT ON CARD TO PROCEDURE EVENT_ANALIT;

GRANT SELECT ON SS_ACCESSUSER TO PROCEDURE EVENT_ANALIT;

GRANT SELECT ON ACCESS TO PROCEDURE EVENT_ANALIT;

GRANT SELECT ON CARDINDEV TO PROCEDURE EVENT_ANALIT;

GRANT SELECT ON DEVICE TO PROCEDURE EVENT_ANALIT;

GRANT EXECUTE ON PROCEDURE EVENT_ANALIT TO SYSDBA;